<?php 
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class CondivisioniFile {
        private $db;
        private $id;
        private $nome;
        private $contenutoDaCondividere;
        private $cartellaDaCondividere;
        private $fileDaCondividere;
        private $destinatari;
        private $testo;
        private $termineCondivisione; 
        
        public function __construct($db, $id, $nome="", $contenutoDaCondividere="", $cartellaDaCondividere=0, $fileDaCondividere=0, $destinatari="", $testo="", $termineCondivisione="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->contenutoDaCondividere = $contenutoDaCondividere;
            $this->cartellaDaCondividere = $cartellaDaCondividere;
            $this->fileDaCondividere     = $fileDaCondividere;
            $this->destinatari           = $destinatari;
            $this->testo                 = $testo;
            $this->termineCondivisione   = $termineCondivisione;
        }

        function crea() {
            $query    = "INSERT INTO `geec_condivisioniFile` (`id`, `nome`, `contenutoDaCondividere`, `cartellaDaCondividere`, `fileDaCondividere`, `destinatari`, `testo`, `termineCondivisione`) 
                            VALUES (NULL, '$this->nome', '$this->contenutoDaCondividere', '$this->cartellaDaCondividere', '$this->fileDaCondividere', '$this->destinatari', '$this->testo', '$this->termineCondivisione');";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE `geec_condivisioniFile` SET nome = '$this->nome', contenutoDaCondividere = '$this->contenutoDaCondividere', cartellaDaCondividere = '$this->cartellaDaCondividere', fileDaCondividere = '$this->fileDaCondividere', destinatari = '$this->destinatari', testo = '$this->testo' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_condivisioniFile",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 19
            eliminaOccorrenzeComponente($this->db,$this->id,19);
        }
        
        function caricaDatiDalDatabase() {
            $datiCondivisione      = $this->db->leggiSingolaRiga("geec_condivisioniFile",$this->id);
            $this->nome            = $datiCondivisione["nome"];
            $this->contenutoDaCondividere = $datiCondivisione["contenutoDaCondividere"];
            $this->cartellaDaCondividere  = $datiCondivisione["cartellaDaCondividere"];
            $this->fileDaCondividere      = $datiCondivisione["fileDaCondividere"];
            $this->destinatari            = $datiCondivisione["destinatari"];
            $this->testo                  = $datiCondivisione["testo"];
            $this->termineCondivisione    = $datiCondivisione["termineCondivisione"];
        }
        
        function duplica($prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_condivisioniFile WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_condivisioniFile SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_condivisioniFile SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        /*
         * Getter & setter
         */
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getContenutoDaCondividere() {
            return $this->contenutoDaCondividere;
        }

        public function getCartellaDaCondividere() {
            return $this->cartellaDaCondividere;
        }

        public function getFileDaCondividere() {
            return $this->fileDaCondividere;
        }

        public function getDestinatari() {
            return $this->destinatari;
        }

        public function getTesto() {
            return $this->testo;
        }

        public function getTermineCondivisione() {
            return $this->termineCondivisione;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setContenutoDaCondividere($contenutoDaCondividere): void {
            $this->contenutoDaCondividere = $contenutoDaCondividere;
        }

        public function setCartellaDaCondividere($cartellaDaCondividere): void {
            $this->cartellaDaCondividere = $cartellaDaCondividere;
        }

        public function setFileDaCondividere($fileDaCondividere): void {
            $this->fileDaCondividere = $fileDaCondividere;
        }

        public function setDestinatari($destinatari): void {
            $this->destinatari = $destinatari;
        }

        public function setTesto($testo): void {
            $this->testo = $testo;
        }

        public function setTermineCondivisione($termineCondivisione): void {
            $this->termineCondivisione = $termineCondivisione;
        }

    }